﻿namespace Code6587EN.Ch07.Layouts.Code6587EN.Ch07
{
    using System;
    using Microsoft.SharePoint;
    using Microsoft.SharePoint.WebControls;
    using Microsoft.SharePoint.Utilities;
    using System.Web;

    /// <summary>
    /// Application page to configure the analytics tracking code for a site collection.
    /// </summary>
    public partial class ConfigureTrackingCode : LayoutsPageBase
    {
        // Name of the property to store the analytics code in 
        private const string PropertyName = "CustomAnalyticsCode";

        protected void Page_Load(object sender, EventArgs e)
        {
            // Wrap the code in an SPMonitoredScope
            // http://msdn.microsoft.com/en-us/library/ff512758(v=office.14).aspx
            using (new SPMonitoredScope("Code6587EN.Ch07.Layouts.Code6587EN.Ch07.ConfigureTrackingCode::Page_Load"))
            {
                // If the request is not a post back (after button submit) and the site already has the property set,
                // add the contents of the property to the text box
                if (!IsPostBack)
                    if (SPContext.Current.Site.RootWeb.AllProperties.ContainsKey(PropertyName))
                        txtScriptBlock.Text = SPContext.Current.Site.RootWeb.AllProperties[PropertyName].ToString();
            }
        }

        // Method to execute when the OK button is clicked
        protected void BtnSubmit_Click(object sender, EventArgs e)
        {
            // Wrap the code in an SPMonitoredScope
            // http://msdn.microsoft.com/en-us/library/ff512758(v=office.14).aspx
            using (new SPMonitoredScope("Code6587EN.Ch07.Layouts.Code6587EN.Ch07.ConfigureTrackingCode::BtnSubmit_Click"))
            {
                // If the root site of the site collection already has the property, set it with the value of the 
                // textbox.  Otherwise create the property and set the value.
                if (SPContext.Current.Site.RootWeb.AllProperties.ContainsKey(PropertyName))
                    SPContext.Current.Site.RootWeb.AllProperties[PropertyName] = txtScriptBlock.Text;
                else
                    SPContext.Current.Site.RootWeb.AllProperties.Add(PropertyName, txtScriptBlock.Text);

                // Update the root site
                SPContext.Current.Site.RootWeb.Update();

                // Redirect back to the Site Settings page
                SPUtility.Redirect(SPContext.Current.Web.ServerRelativeUrl.TrimEnd('/') + "/_layouts/15/Settings.aspx", SPRedirectFlags.Default, HttpContext.Current);
            }
        }
    }
}
